<?php

use App\Http\Controllers\Admin\Auth\LoginController;
use Illuminate\Support\Facades\Route;

Route::middleware('guest:admin')->prefix('admin')->name('admin.')->group(function () {
    Route::get('login', [LoginController::class, 'create'])
        ->name('login');

    Route::post('login', [LoginController::class, 'store']);
});

Route::middleware('auth:admin')->prefix('admin')->name('admin.')->group(function () {
    Route::post('logout', [LoginController::class, 'destroy'])
        ->name('logout');

    // Dashboard
    Route::get('/dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])
        ->name('dashboard');

    // Companies
    Route::get('/companies', [\App\Http\Controllers\Admin\CompanyController::class, 'index'])
        ->name('companies.index');
    Route::get('/companies/create', [\App\Http\Controllers\Admin\CompanyController::class, 'create'])
        ->name('companies.create');
    Route::post('/companies', [\App\Http\Controllers\Admin\CompanyController::class, 'store'])
        ->name('companies.store');
    Route::get('/companies/sample-csv', [\App\Http\Controllers\Admin\CompanyController::class, 'downloadSampleCsv'])
        ->name('companies.sample-csv');
    Route::post('/companies/import-csv', [\App\Http\Controllers\Admin\CompanyController::class, 'importCsv'])
        ->name('companies.import-csv');
    Route::get('/companies/{company}', [\App\Http\Controllers\Admin\CompanyController::class, 'show'])
        ->name('companies.show');
    Route::get('/companies/{company}/edit', [\App\Http\Controllers\Admin\CompanyController::class, 'edit'])
        ->name('companies.edit');
    Route::put('/companies/{company}', [\App\Http\Controllers\Admin\CompanyController::class, 'update'])
        ->name('companies.update');
    Route::delete('/companies/{company}', [\App\Http\Controllers\Admin\CompanyController::class, 'destroy'])
        ->name('companies.destroy');

    // Compliance Groups
    Route::resource('compliance-groups', \App\Http\Controllers\Admin\ComplianceGroupController::class);

    // ADT-1 Compliances
    Route::prefix('adt1')->name('adt1.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\Adt1ComplianceController::class, 'index'])->name('index');
        Route::get('/sample-csv', [\App\Http\Controllers\Admin\Adt1ComplianceController::class, 'downloadSampleCsv'])->name('sample-csv');
        Route::post('/import-csv', [\App\Http\Controllers\Admin\Adt1ComplianceController::class, 'importCsv'])->name('import-csv');
        Route::get('/file/{company}/{session}', [\App\Http\Controllers\Admin\Adt1ComplianceController::class, 'edit'])->name('edit');
        Route::post('/file/{company}/{session}', [\App\Http\Controllers\Admin\Adt1ComplianceController::class, 'store'])->name('store');
    });
});
