<div class="overflow-x-auto">
    <table class="w-full">
        <thead class="bg-gray-50 border-b border-gray-200">
            <tr>
                <th class="px-4 py-2 text-left text-[10px] font-bold text-gray-600 uppercase tracking-wider">Company</th>
                <th class="px-4 py-2 text-left text-[10px] font-bold text-gray-600 uppercase tracking-wider">Appointment Date</th>
                <th class="px-4 py-2 text-left text-[10px] font-bold text-gray-600 uppercase tracking-wider">Filing Details</th>
                <th class="px-4 py-2 text-center text-[10px] font-bold text-gray-600 uppercase tracking-wider">Status</th>
                <th class="px-4 py-2 text-center text-[10px] font-bold text-gray-600 uppercase tracking-wider">Action</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            <?php $__empty_1 = true; $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                
                <?php
                    $record = $company->adt1Compliances->first(); 
                ?>

                <?php
                    $isPending = !$record || $record->status !== 'Filed';
                ?>

                <tr class="<?php echo e($isPending ? 'bg-red-50 hover:bg-red-100' : 'hover:bg-slate-50'); ?>">
                    <td class="px-4 py-2">
                        <div class="text-xs font-semibold text-gray-900"><?php echo e($company->name); ?></div>
                        <div class="text-[10px] text-gray-500 font-mono mt-0.5"><?php echo e($company->cin ?? 'N/A'); ?></div>
                    </td>
                    
                    <td class="px-4 py-2">
                        <?php if($record && $record->date_of_appointment): ?>
                            <span class="text-xs text-gray-700"><?php echo e($record->date_of_appointment->format('d M Y')); ?></span>
                        <?php else: ?>
                            <span class="text-[10px] text-gray-400 italic">-</span>
                        <?php endif; ?>
                    </td>

                    <td class="px-4 py-2">
                        <?php if($record && $record->srn): ?>
                            <div class="text-[10px] text-gray-500">SRN: <span class="font-mono text-gray-900 font-medium"><?php echo e($record->srn); ?></span></div>
                            <div class="text-[10px] text-gray-500">Filed: <span class="text-gray-900"><?php echo e($record->date_of_filing ? $record->date_of_filing->format('d M Y') : '-'); ?></span></div>
                        <?php else: ?>
                            <span class="text-[10px] text-gray-400 italic">Not Filed</span>
                        <?php endif; ?>
                    </td>

                    <td class="px-4 py-2 text-center">
                        <?php if($record): ?>
                            <?php if($record->status === 'Filed'): ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-medium bg-green-100 text-green-800 border border-green-200">
                                    Filed
                                </span>
                            <?php elseif($record->status === 'Pending'): ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-medium bg-amber-100 text-amber-800 border border-amber-200">
                                    Pending
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-medium bg-red-100 text-red-800 border border-red-200">
                                    Overdue
                                </span>
                            <?php endif; ?>
                        <?php else: ?>
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-medium bg-gray-100 text-gray-600 border border-gray-200">
                                Pending
                            </span>
                        <?php endif; ?>
                    </td>

                    <td class="px-4 py-2 text-center">
                        <a href="<?php echo e(route('admin.adt1.edit', ['company' => $company->id, 'session' => $currentSession->id])); ?>" 
                           class="text-[10px] font-medium px-3 py-1 rounded transition-colors
                           <?php echo e($record && $record->status === 'Filed' 
                              ? 'order border-gray-300 bg-white text-gray-700 hover:bg-gray-50' 
                              : 'bg-blue-600 text-white hover:bg-blue-700'); ?>">
                            <?php echo e($record && $record->status === 'Filed' ? 'Edit Details' : 'File Now'); ?>

                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="px-6 py-8 text-center">
                        <p class="text-xs text-gray-500">No companies found for this session.</p>
                        <a href="<?php echo e(route('admin.companies.create')); ?>" class="text-xs text-blue-600 hover:underline mt-1 inline-block">
                            Add a Company first
                        </a>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php if($companies->hasPages()): ?>
    <div class="border-t border-gray-200 px-4 py-3 bg-gray-50">
        <?php echo e($companies->links()); ?>

    </div>
<?php endif; ?>
<?php /**PATH E:\praveen-aggarwal-co\resources\views/admin/adt1/partials/table.blade.php ENDPATH**/ ?>