

<?php $__env->startSection('title', 'ADT-1 Checklist'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto py-4 px-3">
    
    <!-- Header -->
    <div class="flex items-center justify-between mb-4">
        <div>
            <h1 class="text-sm font-semibold text-gray-800 tracking-wide">
                ADT-1 Checklist
            </h1>
             <p class="text-[10px] text-gray-500 mt-0.5">Manage Appointment of Auditors for <?php echo e($currentSession->name); ?></p>
        </div>
        <div class="flex items-center gap-2">
            <!-- Download Sample -->
            <a href="<?php echo e(route('admin.adt1.sample-csv')); ?>" 
               class="flex items-center gap-1 text-[11px] px-3 py-1 border border-gray-300 bg-white text-gray-700 rounded hover:bg-gray-50 transition">
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" /></svg>
                Sample CSV
            </a>

            <!-- Import CSV Button -->
            <button onclick="document.getElementById('csvImportModal').classList.remove('hidden')"
                class="flex items-center gap-1 text-[11px] px-3 py-1 border border-blue-600 bg-blue-600 text-white rounded hover:bg-blue-700 transition shadow-sm">
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" /></svg>
                Import Data
            </button>

            <div class="h-4 w-px bg-gray-300 mx-1"></div>

            <a href="<?php echo e(route('admin.dashboard')); ?>"
                class="text-[11px] px-3 py-1 border border-gray-300 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">
                Dashboard
            </a>
        </div>
    </div>

    <!-- Stats Cards (Compact Filters) -->
    <div class="grid grid-cols-2 gap-3 mb-4">
        
        <!-- Pending Card -->
        <a href="<?php echo e(route('admin.adt1.index', ['session_id' => $currentSession->id, 'status' => 'Pending'])); ?>" 
           class="group bg-white border <?php echo e(request('status') === 'Pending' ? 'border-red-400 ring-1 ring-red-400 bg-red-50' : 'border-gray-200 hover:border-red-300'); ?> rounded-md p-3 shadow-sm transition-all cursor-pointer flex items-center justify-between">
             
             <div class="flex flex-col">
                 <span class="text-[10px] uppercase tracking-wider font-semibold <?php echo e(request('status') === 'Pending' ? 'text-red-700' : 'text-gray-500'); ?>">Pending Filing</span>
                 <span class="text-xl font-bold <?php echo e(request('status') === 'Pending' ? 'text-red-800' : 'text-gray-800'); ?> mt-0.5"><?php echo e($pendingCount); ?></span>
             </div>
             
             <div class="h-8 w-8 rounded-full flex items-center justify-center <?php echo e(request('status') === 'Pending' ? 'bg-red-200 text-red-700' : 'bg-red-50 text-red-500'); ?>">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
             </div>
        </a>

        <!-- Filed Card -->
        <a href="<?php echo e(route('admin.adt1.index', ['session_id' => $currentSession->id, 'status' => 'Filed'])); ?>" 
           class="group bg-white border <?php echo e(request('status') === 'Filed' ? 'border-green-400 ring-1 ring-green-400 bg-green-50' : 'border-gray-200 hover:border-green-300'); ?> rounded-md p-3 shadow-sm transition-all cursor-pointer flex items-center justify-between">
             
             <div class="flex flex-col">
                 <span class="text-[10px] uppercase tracking-wider font-semibold <?php echo e(request('status') === 'Filed' ? 'text-green-700' : 'text-gray-500'); ?>">Filed Successfully</span>
                 <span class="text-xl font-bold <?php echo e(request('status') === 'Filed' ? 'text-green-800' : 'text-gray-800'); ?> mt-0.5"><?php echo e($filedCount); ?></span>
             </div>

             <div class="h-8 w-8 rounded-full flex items-center justify-center <?php echo e(request('status') === 'Filed' ? 'bg-green-200 text-green-700' : 'bg-green-50 text-green-500'); ?>">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                </svg>
             </div>
        </a>

    </div>

    <!-- Filters -->
    <div class="bg-white border border-gray-300 rounded-md shadow-sm mb-4 p-3">
        <form method="GET" action="<?php echo e(route('admin.adt1.index')); ?>" class="grid grid-cols-1 md:grid-cols-4 gap-3">
             <input type="hidden" name="status" value="<?php echo e(request('status')); ?>">

            <!-- Session Filter -->
            <div>
                <label class="block text-[10px] font-semibold text-gray-500 uppercase mb-1">Financial Session</label>
                <select name="session_id" onchange="this.form.submit()"
                    class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0 font-medium">
                    <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($session->id); ?>" <?php echo e($currentSession->id == $session->id ? 'selected' : ''); ?>>
                            <?php echo e($session->name); ?> (<?php echo e($session->status); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <!-- Search -->
            <div class="col-span-2">
                 <label class="block text-[10px] font-semibold text-gray-500 uppercase mb-1">Search Company</label>
                <input type="text" name="search" value="<?php echo e(request('search')); ?>"
                    placeholder="Name or CIN..."
                    class="w-full text-xs px-2 py-1.5 border border-gray-300 rounded focus:border-blue-500 focus:ring-0">
            </div>

            <!-- Clear -->
            <div class="flex items-end">
                <a href="<?php echo e(route('admin.adt1.index')); ?>" 
                   class="w-full text-center text-xs px-3 py-1.5 border border-red-200 bg-red-50 text-red-600 rounded hover:bg-red-100">
                    Reset
                </a>
            </div>
        </form>
    </div>

    <!-- Checklist Table -->
    <div id="table-container" class="bg-white border border-gray-300 rounded-md shadow-sm overflow-hidden min-h-[300px] relative">
        <?php echo $__env->make('admin.adt1.partials.table', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.querySelector('input[name="search"]');
            const tableContainer = document.getElementById('table-container');
            let debounceTimer;
            let currentRequestAbortController = null;

            searchInput.addEventListener('input', function() {
                const query = this.value;
                const form = this.closest('form');
                const url = new URL(form.action);
                
                // Add all form params to URL
                new FormData(form).forEach((value, key) => {
                    url.searchParams.set(key, value);
                });

                // Clear previous timer
                clearTimeout(debounceTimer);

                // Debounce 300ms
                debounceTimer = setTimeout(() => {
                    
                    // Show Loading State (Optional opacity change)
                    tableContainer.classList.add('opacity-50');

                    // Cancel previous pending request if any
                    if (currentRequestAbortController) {
                        currentRequestAbortController.abort();
                    }
                    currentRequestAbortController = new AbortController();

                    fetch(url, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        signal: currentRequestAbortController.signal
                    })
                    .then(response => response.text())
                    .then(html => {
                        tableContainer.innerHTML = html;
                        
                        // Update Browser URL without reload
                        window.history.pushState(null, '', url);
                    })
                    .catch(err => {
                        if (err.name !== 'AbortError') {
                            console.error('Search failed:', err);
                        }
                    })
                    .finally(() => {
                        tableContainer.classList.remove('opacity-50');
                    });

                }, 400); // 400ms delay
            });
        });
    </script>
    <!-- CSV Import Modal -->
    <div id="csvImportModal"
        class="hidden fixed inset-0 bg-gray-900 bg-opacity-50 flex items-center justify-center z-50">
        <div class="bg-white rounded-lg shadow-xl max-w-md w-full mx-4">
            <div class="flex items-center justify-between border-b border-gray-200 px-6 py-4">
                <h3 class="text-sm font-semibold text-gray-800">Import ADT-1 Data</h3>
                <button onclick="document.getElementById('csvImportModal').classList.add('hidden')"
                    class="text-gray-400 hover:text-gray-600">
                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <form action="<?php echo e(route('admin.adt1.import-csv')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="financial_session_id" value="<?php echo e($currentSession->id); ?>">
                <div class="px-6 py-4">
                    <div class="mb-4">
                        <label class="block text-xs font-medium text-gray-700 mb-2">
                            Select CSV File <span class="text-red-500">*</span>
                        </label>
                        <input type="file" name="csv_file" accept=".csv" required
                            class="block w-full text-xs text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                    </div>
                    <div class="bg-blue-50 border border-blue-200 rounded p-3 text-xs text-blue-800">
                        <p class="font-semibold mb-1">📋 Instructions:</p>
                        <ul class="list-disc pl-4 space-y-1">
                            <li>Download the sample CSV first</li>
                            <li>Dates must be <strong>YYYY-MM-DD</strong></li>
                            <li>Ensure CIN matches existing companies</li>
                        </ul>
                    </div>
                </div>
                <div class="border-t border-gray-200 px-6 py-4 flex justify-end gap-2">
                    <button type="button" onclick="document.getElementById('csvImportModal').classList.add('hidden')"
                        class="px-4 py-2 text-xs font-medium text-gray-700 bg-white border border-gray-300 rounded hover:bg-gray-50">
                        Cancel
                    </button>
                    <button type="submit"
                        class="px-4 py-2 text-xs font-medium text-white bg-blue-600 border border-blue-600 rounded hover:bg-blue-700">
                        Import Data
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\praveen-aggarwal-co\resources\views/admin/adt1/index.blade.php ENDPATH**/ ?>